---
sidebar_position: 10
title: AI Code Review Checklist
---

# AI Code Review Checklist

:::danger The "LGTM" Trap
Do not just accept AI-generated code because it "looks about right."
AI models are optimized for plausibility, not correctness. They are masters of the "confident lie."
:::

This checklist defines how to review code generated by LLMs (Copilot, Claude, GPT). Treat AI code like code from a brilliant but inexperienced scholar: perfectly formatted, syntactically correct, but possibly hallucinated or contextually unaware.

---

## 1. Safety & hallucinations (The "Realness" Check)

- [ ] **Phantom Imports:** Verify that all imported libraries actually exist and are installed in `package.json`.
- [ ] **Zombie Methods:** Check that methods called on objects actually exist (AI loves to invent helper methods that *should* be there but aren't).
- [ ] **Silent Failures:** Look for `try { ... } catch (e) { }` blocks where the AI swallowed the error to "make it work".
- [ ] **Type Lies:** Watch out for `as any` or forced type assertions that bypass safety.

---

## 2. Context Blindness (The "Isolation" Check)

- [ ] **Reinventing the Wheel:** Did the AI write a new utility function (e.g., `formatDate`) when a standard project utility already exists?
- [ ] **Pattern Drift:** Is it using `fetch` directly when the project standard is to use a custom `apiClient` wrapper?
- [ ] **Style Regressions:** Did it suddenly switch from Tailwind classes to inline CSS, or from functional components to classes?

---

## 3. Logic & Edge Cases

- [ ] **Happy Path Only:** AI often ignores `null`, `undefined`, or empty array states. Ask: "What happens if this list is empty?"
- [ ] **Hardcoded Values:** Check for magic numbers, hardcoded URLs, or (worst case) dummy API keys/tokens.
- [ ] **Off-by-One:** Loops and array indexing generate frequent subtle bugs.

---

## 4. Security & Privacy

- [ ] **Data Leaks:** Ensure no PII (Personally Identifiable Information) is logged to the console.
- [ ] **Injection Flaws:** Check SQL queries or HTML rendering (XSS) for proper escaping.

---

## 5. Review Strategy

### The "Explain It" Prompt
If a block of AI code is complex, do not just read it. Paste it back into the chat and ask:
> "Explain this code line by line. Why did you choose this approach over [Alternative X]?"

If the AI cannot defend its own code, reject it.

### Refactoring Rule
**Never** accept code that you do not fully understand. If you can't debug it, you don't own it.
